class Stats_Novice extends Mutator config(MonsterMatchStatistics);

var bool bSaved;
var int slot;

struct Data
{
var string Name;
var int Score;
};

var config Data DB[10000];
var Data temp[128];

function PostBeginPlay()
{
local int i;

	for ( i=0; i<128; i++ )
		{
		temp[i].Name = "";
		temp[i].Score = 0;
		}

	SetTimer(1.0,True);
}

function bool HandleEndGame()
{
local Pawn P;

	Super.HandleEndGame();

	if (!bSaved)
		{
		Timer();
		UpdateDB();
		SaveConfig();
		}
	bSaved = True;

	if (NextMutator != None)
		return (NextMutator.HandleEndGame());
}

function UpdateDB()
{
local int i, ii;

	for ( i=0; i<128; i++ )
		{
		if ( temp[i].Name != "" )
			{
			for ( ii=0; ii<10000; ii++ )
				{
				if ( DB[ii].Name == temp[i].Name || DB[ii].Name == "" )
					{
					if ( DB[ii].Name == "" )
						{
						DB[ii].Name = temp[i].Name;
						DB[ii].Score = temp[i].Score;
						ii = 50000;
						}
					else
						{
						DB[ii].Score += temp[i].Score;
						ii = 50000;
						}
					}
				}
			}
		}

}

function Timer()
{
local Pawn P;
local int i;
local MonsterPRI PRI;

	for (P = Level.PawnList; P != None; P = P.NextPawn)
		{
		if ( P.IsA('PlayerPawn') )
			{
			PRI = MonsterPRI(PlayerPawn(P).PlayerReplicationInfo);
			if ( PRI != none )
				{
				PRI.Player1 = DB[0].Name$", score:"$string(DB[0].Score);
				PRI.Player2 = DB[1].Name$", score:"$string(DB[1].Score);
				PRI.Player3 = DB[2].Name$", score:"$string(DB[2].Score);
				PRI.Player4 = DB[3].Name$", score:"$string(DB[3].Score);
				PRI.Player5 = DB[4].Name$", score:"$string(DB[4].Score);
				PRI.Player6 = DB[5].Name$", score:"$string(DB[5].Score);
				PRI.Player7 = DB[6].Name$", score:"$string(DB[6].Score);
				PRI.Player8 = DB[7].Name$", score:"$string(DB[7].Score);
				PRI.Player9 = DB[8].Name$", score:"$string(DB[8].Score);
				PRI.Player10 = DB[9].Name$", score:"$string(DB[9].Score);
				}
			for ( i=0; i<128; i++ )
				{
				if ( temp[i].Name == "" || temp[i].Name == P.PlayerReplicationInfo.PlayerName )
					{
					temp[i].Name = P.PlayerReplicationInfo.PlayerName;
					temp[i].Score = P.PlayerReplicationInfo.Score;
					i = 500;
					}
				}
			}
		}
}

function Tick(float DeltaTime)
{
local string s;
local int i;

	Super.Tick(DeltaTime);

	if ( DB[slot+1].Name != "" && DB[slot+1].Score > DB[slot].Score )
		{
		s = DB[slot].Name;
		i = DB[slot].Score;
		DB[slot].Name = DB[slot+1].Name;
		DB[slot].Score = DB[slot+1].Score;
		DB[slot+1].Name = s;
		DB[slot+1].Score = i;
		}
	else if ( DB[slot+1].Name == "" )
		slot = 0;

	slot++;
	if ( slot > 9999 )
		slot = 0;
}

defaultproperties
{
bSaved=False
slot=0
}

